#ifndef _GENERIC_SIGNAL_H_
#define _GENERIC_SIGNAL_H_

#include "bytes.h"

typedef struct __Signal_dictionary _Signal_dictionary;
typedef _Signal_dictionary *Signal_dictionary;

typedef struct _Signal_state {
    char id;
    bytes gamma;
    bytes T[2]; // @TODO: use dynamic array
    bytes sigma;
    bytes omega_send;
    bytes omega_recv;
    size_t l;
    size_t t;
    size_t i_send;
    size_t i_recv;
    Signal_dictionary D;
} Signal_state;

void Signal_init_send(bytes_i k_root, bytes_i k_CKA, Signal_state *state);
void Signal_init_recv(bytes_i k_root, bytes_i k_CKA, Signal_state *state);

void Signal_free(Signal_state *state);

typedef struct _Signal_header {
    bytes T[2]; // @TODO: use dynamic array
    size_t l;
    size_t t;
    size_t i;
} Signal_header;

void Signal_send(Signal_state *state, bytes_i m, Signal_header *h, bytes_O c);

typedef enum _bool {false, true} bool;

int Signal_recv(Signal_state *state, bytes_i c, const Signal_header *h, bool *use_cka_free, bytes_O m);

extern const bool SIGNAL_FREE_HEADER_AT_SEND;

void Signal_free_header(Signal_header *h, bool use_cka_free);

#endif
