#include "../prgf.h"

#include <stdlib.h>

void _prg(bytes_i seed, bytes_o outputs, size_t n_outputs) {
    uint32_t s = 0;
    for (size_t i = 0; i < seed->l / 4; ++i) {
        s += ((uint32_t *)seed->p)[i];
    }
    srand(s);
    for (size_t j = 0; j < n_outputs; ++j) {
        bytes_o output = &outputs[j];
        for (size_t i = 0; i < output->l; ++i) {
            output->p[i] = (uint8_t)rand();
        }
    }
}

void prgf_init(bytes_i seed, bytes_o state) {
    _prg(seed, state, 1);
}
void prgf_update(bytes_i state, bytes_i input, bytes_o output, bytes_o state_new) {
    bytes outputs[2] = {*state_new, *output};
    _prg((bytes_i)state, outputs, 2);
}
