#include "../prf.h"

// @Note: SHA is also considered PRF.

#include <botan/ffi.h>

size_t PRF_OUTPUT_L() {
    botan_mac_t ctx;
    assert(botan_mac_init(&ctx, "HMAC(SHA-512)", 0) == 0);
    size_t output_l;
    assert(botan_mac_output_length(ctx, &output_l) == 0);
    assert(botan_mac_destroy(ctx) == 0);
    return output_l;
}

void prf(bytes_i key, bytes_i input, uint8_t *output) {
    botan_mac_t ctx;
    assert(botan_mac_init(&ctx, "HMAC(SHA-512)", 0) == 0);
    assert(botan_mac_set_key(ctx, key->p, key->l) == 0);
    assert(botan_mac_update(ctx, input->p, input->l) == 0);
    assert(botan_mac_final(ctx, output) == 0);
    assert(botan_mac_destroy(ctx) == 0);
}
