#include "../hmac.h"

#include <botan/ffi.h>

size_t HMAC_OUTPUT_L() {
    botan_mac_t ctx;
    assert(botan_mac_init(&ctx, "HMAC(SHA-256)", 0) == 0);
    size_t output_l;
    assert(botan_mac_output_length(ctx, &output_l) == 0);
    assert(botan_mac_destroy(ctx) == 0);
    return output_l;
}

void hmac(bytes_i key, bytes_i inputs, size_t n_inputs, uint8_t *output) {
    botan_mac_t ctx;
    assert(botan_mac_init(&ctx, "HMAC(SHA-256)", 0) == 0);
    assert(botan_mac_set_key(ctx, key->p, key->l) == 0);
    for (size_t i = 0; i < n_inputs; ++i) {
        assert(botan_mac_update(ctx, inputs[i].p, inputs[i].l) == 0);
    }
    assert(botan_mac_final(ctx, output) == 0);
    assert(botan_mac_destroy(ctx) == 0);
}
