#include "../hkdf.h"

#include <botan/ffi.h>

#include <string.h>

void hkdf(bytes_i salt, bytes_i input, bytes_i info, bytes_o outputs, size_t n_outputs) {
    size_t l_outputs = 0;
    for (size_t i = 0; i < n_outputs; ++i) {
        l_outputs += outputs[i].l;
    }
    bytes output = alloc_bytes(l_outputs);
    assert(botan_kdf("HKDF(SHA-512)", output.p, output.l, input->p, input->l, salt->p, salt->l, info->p, info->l) == 0);
    for (size_t i = 0, l = 0; i < n_outputs; ++i) {
        memcpy(outputs[i].p, output.p + l, outputs[i].l);
        l += outputs[i].l;
    }
    free_bytes(as_const_bytes(&output));
}
