#include "../cka.h"

#include <botan/ffi.h>

size_t CKA_SEED_N() {
    return 2;
}

static const size_t PK_L = 32;
static const size_t SK_L = 120;

void cka_rand_seed(bytes_O seeds) {
    botan_rng_t rng;
    assert(botan_rng_init(&rng, NULL) == 0);
    botan_privkey_t sk;
    assert(botan_privkey_create_ecdh(&sk, rng, "curve25519") == 0);
    assert(botan_rng_destroy(rng) == 0);

    seeds[0] = alloc_bytes(PK_L);
    size_t _pk_l = PK_L;
    assert(botan_pk_op_key_agreement_export_public(sk, seeds[0].p, &_pk_l) == 0);
    assert(_pk_l == PK_L);

    seeds[1] = alloc_bytes(SK_L);
    size_t _sk_l = SK_L;
    assert(botan_privkey_export(sk, seeds[1].p, &_sk_l, BOTAN_PRIVKEY_EXPORT_FLAG_PEM) == 0);
    assert(_sk_l == SK_L);
    assert(botan_privkey_destroy(sk) == 0);
}

void cka_init_send(bytes_i seeds, bytes_O k_send) {
    *k_send = __WARN__to_bytes(seeds[0]);
}
void cka_init_recv(bytes_i seeds, bytes_O k_recv) {
    *k_recv = __WARN__to_bytes(seeds[1]);
}

void cka_free_seed(bytes_I seeds) {
    // @Note: seeds are already completely used as k_send and k_recv
}

size_t CKA_CT_N() {
    return 1;
}

void cka_send(uint8_t id, bytes_i k_send, bytes_O cts, bytes_O k, bytes_O k_recv) {
    botan_rng_t rng;
    assert(botan_rng_init(&rng, NULL) == 0);
    botan_privkey_t sk;
    assert(botan_privkey_create_ecdh(&sk, rng, "curve25519") == 0);
    assert(botan_rng_destroy(rng) == 0);

    cts[0] = alloc_bytes(PK_L);
    size_t _pk_l = PK_L;
    assert(botan_pk_op_key_agreement_export_public(sk, cts[0].p, &_pk_l) == 0);
    assert(_pk_l == PK_L);

    botan_pk_op_ka_t ka;
    assert(botan_pk_op_key_agreement_create(&ka, sk, "KDF2(SHA-256)", 0) == 0);
    size_t l;
    assert(botan_pk_op_key_agreement_size(ka, &l) == 0);
    *k = alloc_bytes(l);
    size_t _l = l;
    assert(botan_pk_op_key_agreement(ka, k->p, &_l, k_send->p, k_send->l, NULL, 0) == 0);
    assert(_l == l);
    assert(botan_pk_op_key_agreement_destroy(ka) == 0);

    *k_recv = alloc_bytes(SK_L);
    size_t _sk_l = SK_L;
    assert(botan_privkey_export(sk, k_recv->p, &_sk_l, BOTAN_PRIVKEY_EXPORT_FLAG_PEM) == 0);
    assert(_sk_l == SK_L);
    assert(botan_privkey_destroy(sk) == 0);
}

void cka_recv(uint8_t id, bytes_i k_recv, bytes_i cts, bytes_O k, bytes_O k_send) {
    botan_privkey_t sk;
    assert(botan_privkey_load(&sk, NULL, k_recv->p, k_recv->l, NULL) == 0);

    *k_send = __WARN__to_bytes(cts[0]);

    botan_pk_op_ka_t ka;
    assert(botan_pk_op_key_agreement_create(&ka, sk, "KDF2(SHA-256)", 0) == 0);
    size_t l;
    assert(botan_pk_op_key_agreement_size(ka, &l) == 0);
    *k = alloc_bytes(l);
    size_t _l = l;
    assert(botan_pk_op_key_agreement(ka, k->p, &_l, k_send->p, k_send->l, NULL, 0) == 0);
    assert(_l == l);
    assert(botan_pk_op_key_agreement_destroy(ka) == 0);
    assert(botan_privkey_destroy(sk) == 0);
}

void cka_free_ct(bytes_I cts) {
    // @Note: cts[0] is already used as k_send
}
