#include "../_frodo_patch.c"
#include "../_frodo_patch_0.c"
#include "../_frodo_patch_1.c"

static const size_t PK_L = CRYPTO_PUBLICKEYBYTES;
static const size_t SK_L = CRYPTO_SECRETKEYBYTES;
static const size_t CT_L = (PARAMS_LOGQ*PARAMS_N*PARAMS_NBAR)/8 + (PARAMS_NBAR*PARAMS_NBAR)/8;
static const size_t K_L = BYTES_MU;

size_t CKA_SEED_N() {
    return 2;
}

void cka_rand_seed(bytes_O seeds) {
    seeds[0] = alloc_bytes(PK_L);
    seeds[1] = alloc_bytes(SK_L);
    frodo_gen(seeds[0].p, seeds[1].p);
}

void cka_init_send(bytes_i seeds, bytes_O k_send) {
    *k_send = __WARN__to_bytes(seeds[0]);
}
void cka_init_recv(bytes_i seeds, bytes_O k_recv) {
    *k_recv = __WARN__to_bytes(seeds[1]);
}

void cka_free_seed(bytes_I seeds) {
    // @Note: seeds are already completely used as k_send and k_recv
}

size_t CKA_CT_N() {
    return 1;
}

void cka_send(uint8_t id, bytes_i k_send, bytes_O cts, bytes_O k, bytes_O k_recv) {
    cts[0] = alloc_bytes(CT_L);
    *k = alloc_bytes(K_L);
    *k_recv = alloc_bytes(SK_L);
    if (id) {
        frodo_enc_transpose(k_recv->p, k->p, cts[0].p, k_send->p);
    } else {
        frodo_enc(k_recv->p, k->p, cts[0].p, k_send->p);
    }
}
void cka_recv(uint8_t id, bytes_i k_recv, bytes_i cts, bytes_O k, bytes_O k_send) {
    *k = alloc_bytes(K_L);
    *k_send = alloc_bytes(PK_L);
    if (id) {
        frodo_dec(k_send->p, k->p, cts[0].p, k_recv->p);
    } else {
        frodo_dec_transpose(k_send->p, k->p, cts[0].p, k_recv->p);
    }
}

void cka_free_ct(bytes_I cts) {
    free_bytes(&cts[0]);
}
